-- US6043 - General export window
global PX_EXPORTER_EXPORTING = 1
global PX_EXPORTER_SELECTED_ONLY = 2
global PX_EXPORTER_VISIBLE_ONLY = 4

struct PxExporterParameters
(
	bFolderName = false,
	sFolderName = "",
	bIncludeFBX = true,
	bExportPhysXScene = true,
	iPhysXSceneFormat = 1,
	bExportClothing = true,
	bExportDestruction = true,
	iClothingFormat = 1,
	iDestructionFormat = 1,
	bExportCTP = true,
	bExportCTW = true,
	iTriangleWindingReverse = 1,
	bIncludeHulls = true,
	bOmitMeshSubpartName = false,
	bValidateScne = false,
	bSelectedOnly = false,
	sLastSavingFolder = "",
	sLastSavingName = "",
	fileNameInputDone = false
)

PxExporterParameters = PxExporterParameters()



fn PxExportFBX filename exportSelected =
(
	pluginManager.loadClass FBXEXP 
	
	--FBXExporterSetParam "ASCII" true 	
	FBXExporterSetParam "Animation" true 
	local validParam = FBXExporterGetParam "ForceNormalsByControlPoint"
	if (unsupplied != validParam) do FBXExporterSetParam "ForceNormalsByControlPoint" false 
	FBXExporterSetParam "GeomAsBone" true 
	FBXExporterSetParam "BakeAnimation" true -- set to bake animation to ensure exporting to Clothing Tool works
	FbxExporterSetParam "NormalsPerPoly" false
	FBXExporterSetParam "Skin" true
	FBXExporterSetParam "Shape" true
	FBXExporterSetParam "PointCache" false 
	FBXExporterSetParam "Removesinglekeys" true
	FBXExporterSetParam "Export|IncludeGrp|Animation|CurveFilter" true
	FBXExporterSetParam "Export|IncludeGrp|Animation|CurveFilter|CurveFilterApplyUnroll" true
	FBXExporterSetParam "FilterKeyReducer" false 
	FBXExporterSetParam "Cameras" false 
	FBXExporterSetParam "Lights" false 
	FBXExporterSetParam "EmbedTextures" true 
	FBXExporterSetParam "UpAxis" "Z" 
	FBXExporterSetParam "ShowWarnings" false
	-- ConvertUnit and ScaleFactor work together to  make FBX Viewer work right
	FBXExporterSetParam "ConvertUnit" "auto"
	FBXExporterSetParam "FileVersion" "FBX201000" 
	FBXExporterSetParam "ScaleFactor" 1.0
	
	ExportFile filename #noPrompt selectedOnly:exportSelected using:FBXEXP

	true
)


rollout px_exporter_general "General Settings"
(
	checkbox		cb_folder_name		"Folder Name"	checked:false width:80 align:#left across:2
	edittext		txt_folder_name		"" width:75 height: 11 offset:[5, 0]
	checkbox		cb_include_fbx		"Include FBX"   checked:true
	
	fn SetEnableStateToControls =
	(
		txt_folder_name.readonly = not cb_folder_name.checked
		txt_folder_name.enabled = cb_folder_name.checked
	)
	
	on cb_folder_name changed value do
	(
		SetEnableStateToControls()
	)
	
	on px_exporter_general open do
	(
		px_exporter_general.title = nvpxText.guiExportGeneralSettings
		cb_folder_name.text = nvpxText.guiExportFolderName
		cb_include_fbx.text = nvpxText.guiExportIncludeFbx
	)
)

rollout px_exporter_scene_settings "PhysX Scene Settings"
(
	checkbox		cb_export_scene		"Export PhysX Scene"   checked:true
	group "File Format"
	(
		radiobuttons	rb_file_format		labels:#(nvpxText.guiExportXML, nvpxText.guiExportBinary) offset:[-5, 0] columns:2
	)
	
	on px_exporter_scene_settings open do
	(
		px_exporter_scene_settings.title = nvpxText.guiExportSceneSettings
		cb_export_scene.text = nvpxText.guiExportScene
		px_exporter_scene_settings.controls[2].text = nvpxText.guiExportFileFormat
		
		rb_file_format.state = 2
	)
)



rollout px_exporter_clothing "APEX Clothing Settings"
(
	checkbox		cb_export_clothing  "Export APEX Clothing"   checked:true

	group "File Format"
	(
		radiobuttons	rb_file_format		labels:#("APB", "APX") offset:[-5, 0] columns:2
	)

	group "Also Export"
	(
		checkbox		cb_also_export_ctp  "CTP"   checked:true  width:50 offset:[20, 0] across:2
		checkbox		cb_also_export_ctw  "CTW"   checked:true  width:50 offset:[-2, 0]
	)
	label				lbl_triangle_winding		"Triangle Winding"  align:#left  offset:[0,  2]  across:2
	dropdownlist		dl_triangle_winding			""  items:#("Standard","Reverse")  offset:[10, 0]
	checkbox			cb_include_collision_hulls  "Include collision hulls"  checked:true
	checkbox			cb_omit_subpart_name        "Omit mesh subpart names"  checked:false

	--fn ExportClothingToFile fileName =
	fn ExportClothingToFile exportAPEXClothing =
	(
		ext = if (px_exporter_clothing.rb_file_format.state == 1) then ".apb" else ".apx"
		--destfilename = fileName + ext
		-- prepare exporting parameters
		modelSpace = true -- model space (not supported yet)
		scaleValue = 1.0  -- set scale value
		addHulls = cb_include_collision_hulls.checked   -- need hull information
		exportCTP = cb_also_export_ctp.checked  -- export CTP
		exportCTW = cb_also_export_ctw.checked  -- export CTW
		exportFBX = false  -- export FBX;      ==> we use another script function to export fbx
		exportSelected = (nvpx.GetExporterMode PX_EXPORTER_SELECTED_ONLY)  -- export all APEX clothing nodes
		launchViewer = false  -- launch APEX viwer after exporting
		reverseWinding = (px_exporter_clothing.dl_triangle_winding.selection == 2) -- reverse triangle winding
		omitMeshSubpartName = cb_omit_subpart_name.checked
		--nvpx.SaveAPEXClothing destfilename modelSpace scaleValue addHulls exportCTW exportFBX exportCTP exportSelected launchViewer reverseWinding omitMeshSubpartName
		nvpx.PrepExportAPEXClothing exportAPEXClothing ext modelSpace scaleValue addHulls exportCTW exportCTP exportSelected launchViewer reverseWinding omitMeshSubpartName
	)
	
	fn HaveMultipleLods nodes =
	(
		findMultipleLods = false
		for i in nodes do 
		(
			m = i.modifiers["APEX Clothing"];
			if (m != undefined) and (m.lodmeshes.count > 1) do
			(
				findMultipleLods = true
				exit
			)
		)
		findMultipleLods
	)
	
	fn IsThereClothing nodes =
	(
		findClothing = false
		for i in nodes do 
		(
			m = i.modifiers["APEX Clothing"];
			if m != undefined do (findClothing = true; exit)
		)
		findClothing
	)
	
	fn EnableClothingControls value = 
	(
		rb_file_format.enabled = value
		cb_also_export_ctp.enabled = value
		cb_also_export_ctw.enabled = value
		lbl_triangle_winding.enabled = value
		dl_triangle_winding.enabled = value
		cb_include_collision_hulls.enabled = value
		cb_omit_subpart_name.enabled = value and (not HaveMultipleLods(geometry))
		if not cb_omit_subpart_name.enabled do cb_omit_subpart_name.checked = false
	)
	
	on cb_export_clothing changed value do 
	(
		EnableClothingControls value
	)
	
	fn SetEnableStateToControls =
	(
		cb_export_clothing.enabled = IsThereClothing(geometry)
		cb_export_clothing.checked = cb_export_clothing.enabled
		EnableClothingControls(cb_export_clothing.enabled)
	)
	
	on px_exporter_clothing open do
	(
		px_exporter_general.title = nvpxText.guiExportGeneralSettings
		cb_export_clothing.text = nvpxText.guiExportClothing
		px_exporter_clothing.controls[2].text = nvpxText.guiExportFileFormat
		px_exporter_clothing.controls[5].text = nvpxText.guiExportAlsoExport
		dl_triangle_winding.text = nvpxText.guiExportTriangleWinding
		cb_include_collision_hulls.text = nvpxText.guiExportIncludeCollisionHulls
		cb_omit_subpart_name.text = nvpxText.guiExportOmitMeshSubpartNames
	)
)


rollout px_exporter_destruction "APEX Destruction Settings"
(
	checkbox		cb_export_destruction  "Export APEX Destruction"   checked:true

	group "File Format"
	(
		radiobuttons	rb_file_format		labels:#("APB", "APX") offset:[-5, 0] columns:2
	)

	fn ExportDestructionToFile exportAPEXDestruction =
	(
		ext = if (px_exporter_destruction.rb_file_format.state == 1) then ".apb" else ".apx"
		-- prepare exporting parameters
		exportSelected = (nvpx.GetExporterMode PX_EXPORTER_SELECTED_ONLY)  -- export all APEX clothing nodes
		nvpx.PrepExportAPEXDestruction exportAPEXDestruction ext exportSelected
	)
	
	fn IsThereDestruction nodes =
	(
		findDestruction = false
		for i in nodes do 
		(
			if (classof(i.baseObject) == Destruction) do
			(
				findDestruction = true
			)
		)
		findDestruction
	)
	
	fn EnableDestructionControls value = 
	(
		rb_file_format.enabled = value
	)
	
	on cb_export_destruction changed value do 
	(
		EnableDestructionControls value
	)
	
	fn SetEnableStateToControls =
	(
		cb_export_destruction.enabled = IsThereDestruction(helpers)
		cb_export_destruction.checked = cb_export_destruction.enabled
		EnableDestructionControls(cb_export_destruction.enabled)
	)
	
	on px_exporter_destruction open do
	(
		cb_export_destruction.text = nvpxText.guiExportDestruction
		px_exporter_destruction.controls[2].text = nvpxText.guiExportFileFormat
	)
)

rollout px_exporter_options "PhysX Export Options"
(
	subRollout 		theSubRollout 	width:190 height:384 pos:[5, 5]
	checkbox        cb_exportSelectedOnly "Only export selected objects" align:#left offset:[-5, 0] checked:false tooltip:nvpxText.guiOnlyExportSelected
	checkbox        cb_exportVisibleOnly "Only export visible objects" align:#left offset:[-5, 0] checked:false tooltip:nvpxText.guiOnlyExportVisible
	checkbox		cb_validateScene	"Validate scene before export"	align:#left offset:[-5, 0] checked:false tooltip:nvpxText.guiExportValidateScene
	button			bt_export           "Export" width:80 align:#left across:2
	button			bt_cancel           "Cancel" width:80 --offset:[-5, 0] 
	
	fn refreshPage = 
	(
		removeSubRollout 		theSubRollout	px_exporter_general
		removeSubRollout 		theSubRollout	px_exporter_scene_settings
		if px_exporter_clothing.open do removeSubRollout 		theSubRollout	px_exporter_clothing
		if px_exporter_destruction.open do removeSubRollout		theSubRollout	px_exporter_destruction
		addSubRollout			theSubRollout	px_exporter_general
		addSubRollout			theSubRollout	px_exporter_scene_settings
		if nvpx.IsApexAvailable() do addSubRollout			theSubRollout	px_exporter_clothing
		if nvpx.IsApexAvailable() do addSubRollout			theSubRollout	px_exporter_destruction
	)
	
	fn SavePos =
	(
		iniFile = getdir #maxData
		iniFile = iniFile + "NvPhysXPlugin.ini"
		pos = GetDialogPos px_exporter_options
		setINISetting iniFile "DialogExportOptions" "PosX" (pos.x as string)
		setINISetting iniFile "DialogExportOptions" "PosY" (pos.y as string)
	)
	
	fn LoadPos =
	(
		iniFile = getdir #maxData
		iniFile = iniFile + "NvPhysXPlugin.ini"
		hasInit = hasINISetting iniFile "DialogExportOptions"
		if hasInit then
		(
			posx = (GetINISetting iniFile "DialogExportOptions" "PosX") as float
			posy = (GetINISetting iniFile "DialogExportOptions" "PosY") as float
			pos = [posx, posy]
		)
		else
		(
			pos = [100, 100]
		)
	)
	
	fn closeDialog =
	(
		PxExporterParameters.fileNameInputDone = false
		if px_exporter_options.open do
		(
			DestroyDialog px_exporter_options
		)
		--format " last names: % % \n" PxExporterParameters.sLastSavingFolder 	PxExporterParameters.sLastSavingName
	)
	
	fn AgreeToOverwrite savingPath =
	(
		local folderExit = doesFileExist savingPath
		if folderExit then
		(
			local info = stringstream ""
			format "% already exists. Do you want to replace it?" savingPath to:info
			(queryBox (info as string) title:"Save to folder")
		)
		else
		(
			true -- return value
		)
	)

	fn SaveToDisk =
	(
		-- check whether user inputs a folder name
		local savingPath = ""
		local projectName = ""
		local physxSceneFile = ""
		if px_exporter_general.cb_folder_name.checked then
		(
			trimSpace = " \t\r\n"
			savingPath = px_exporter_general.txt_folder_name.text
			savingPath = trimleft savingPath trimSpace
			savingPath = trimright savingPath trimSpace
			tokens = filterString savingPath "\\" splitEmptyTokens:false
			if tokens.count > 0 do projectName = tokens[tokens.count]
		)
		
		--local isPresetPath = doesFileExist savingPath   -- user already provide a full path
		-- let user input project name
		(
			local format_ext = "pxproj"
			local fullname = PxExporterParameters.sLastSavingFolder + PxExporterParameters.sLastSavingName;
			--format "fullname = %\n" fullname
			--if isPresetPath do fullname = savingPath + PxExporterParameters.sLastSavingName; -- use this inputed path
			if PxExporterParameters.fileNameInputDone do  -- PxExporterParameters.fileNameInputDone is set in C++
			(
				projectName = PxExporterParameters.sLastSavingName
				if savingPath.count > 0 then
					savingPath = (PxExporterParameters.sLastSavingFolder + savingPath + "\\")
				else
					savingPath = PxExporterParameters.sLastSavingFolder
				--format "savingPath = % projectName = % folder = % \n" savingPath projectName (PxExporterParameters.sLastSavingFolder)
			)
			while not PxExporterParameters.fileNameInputDone do
			(
				local searchmask = "PhysX Project(*." + format_ext + ")|*." + format_ext;
				fullname = getsavefilename filename:fullname types:searchmask;
				PxExporterParameters.fileNameInputDone = true
				if fullname != undefined do
				(
					local projExit = doesFileExist fullname
					inputedPath = getFilenamePath fullname
					projectName = getFilenameFile fullname
					--format "1 inputedPath = % savingPath = % projectName = %\n" inputedPath savingPath projectName
					if savingPath.count > 0 then
					(
						savingPath = inputedPath + savingPath + "\\"       -- use only provide a folder name, not a full path
						if not AgreeToOverwrite savingPath do PxExporterParameters.fileNameInputDone = false
					)
					else
					(
						savingPath = inputedPath
					)
				)
			)
		)
		--format "savingPath = % projectName = %\n" savingPath projectName
		local folderCreated = doesFileExist savingPath
		if not folderCreated do folderCreated = makeDir savingPath all:true
		if not folderCreated then
		(
			false   -- return value
		)
		else
		(
			if (savingPath.count > 0) then -- user provides right path
			(
				-- export FBX
				local fbxName = ""
				if px_exporter_general.cb_include_fbx.checked do
				(
					fbxName = projectName + ".fbx"
					local filename = savingPath + fbxName
					PxExportFBX filename (nvpx.GetExporterMode PX_EXPORTER_SELECTED_ONLY)
				)

				-- export clothing
				if px_exporter_clothing.open do px_exporter_clothing.ExportClothingToFile px_exporter_clothing.cb_export_clothing.checked
				
				-- export destruction
				if px_exporter_destruction.open do px_exporter_destruction.ExportDestructionToFile px_exporter_destruction.cb_export_destruction.checked

				-- export scene
				local physx_ext = "xml";
				if px_exporter_scene_settings.rb_file_format.state == 1 then
				(
					if(nvpx.GetPhysXSDKVersionMajor() == 3) do physx_ext = "RepX"
				)
				else
				(
					if(nvpx.GetPhysXSDKVersionMajor() == 3) then
					(
						physx_ext = "bin"
					)
					else
					(
						physx_ext = "nxb"
					)
				)
				
				physxSceneFile = savingPath + projectName + format_ext

				-- check whether to create physx scene to export. if true, prep data
				local needClearPhysXScene = not nvpx.IsSimulating()
				PxCreatePhysXScene()
				nvpx.PrepExportPhysXScene px_exporter_scene_settings.cb_export_scene.checked physx_ext
				--if px_exporter_scene_settings.cb_export_scene.checked do
				--(
				--	format "before export PhysX scene '%'!\n" physxSceneFile
				--	local result = nvpx.ExportPhysXScene physxSceneFile physx_ext
				--	if (result != 0) then
				--	(
				--		format "Failed to export PhysX scene '%'!\n" physxSceneFile
				--	) else
				--	(
				--		format "PhysX scene is exported to '%'.\n" physxSceneFile
				--	)
				--)

				-- export project
				--nvpx.ExportPhysXProjectFile savingPath projectName
				nvpx.ExportPhysXProject savingPath projectName fbxName
				format "PhysX project is exported to '%'.\n" (savingPath)
				if needClearPhysXScene then PxStopSimulation()

				true   -- return value
			)
			else
			(
				false   -- return value
			)
		)
	)
	
	fn CheckValidatyOk =
	(
		true
	)
	
	on bt_export pressed do
	(
		global PxExporterSaveLastParameters
		
		if CheckValidatyOk() then
		(
			local selectedOnly = cb_exportSelectedOnly.checked
			local visibleOnly = cb_exportVisibleOnly.checked
			doExport = TRUE
			if cb_validateScene.checked do (doExport = nvpx.ShowValidateScene true)
			if (doExport) do
			(
				nvpx.SetExporterMode PX_EXPORTER_EXPORTING TRUE
				local preSelection = #()
				local newSelection = #()
				local needRestoreSelection = visibleOnly  -- fbx does not support export visiable only; fake it using selectedOnly
				if needRestoreSelection then
				(
					-- backup selection
					for n in $selection do append preSelection n
					
					-- make new selection
					if selectedOnly then
					(
						for n in $selection do ( if not n.ishidden do append newSelection n )
					)
					else
					(
						for n in $objects do ( if not n.ishidden do append newSelection n )
					)
					
					-- select them
					select newSelection
				)
				
				-- set flag
				nvpx.SetExporterMode PX_EXPORTER_SELECTED_ONLY (selectedOnly or visibleOnly)

				if selectedOnly then
					nvpx.SetBehaviorReason gPxReasonExport gPxReasonModifierNone     -- deep system needs
				else
					nvpx.SetBehaviorReason gPxReasonExport gPxReasonModifierSelected     -- deep system needs
				SaveToDisk()
				nvpx.SetBehaviorReason gPxReasonPlayback gPxReasonModifierNone -- deep system needs
				--format "pre selection: %\n" preSelection
				if needRestoreSelection then select preSelection
			)
			nvpx.SetExporterMode PX_EXPORTER_SELECTED_ONLY (selectedOnly)
			nvpx.SetExporterMode PX_EXPORTER_VISIBLE_ONLY (visibleOnly)
			nvpx.SetExporterMode PX_EXPORTER_EXPORTING FALSE
			
			PxExporterSaveLastParameters()
			closeDialog()
		)
	)
	
	on bt_cancel pressed do
	(
		closeDialog()
	)
	
	on px_exporter_options open do
	(
		px_exporter_options.title = nvpxText.guiExportOptions
		cb_validateScene.text = nvpxText.guiExportValidateScene
		cb_exportSelectedOnly.text = nvpxText.guiOnlyExportSelected
		cb_exportVisibleOnly.text = nvpxText.guiOnlyExportVisible
		bt_export.text = nvpxText.guiExportExport
		bt_cancel.text = nvpxText.guiExportCancel
		
		refreshPage()
	)
	
	on px_exporter_options close do
	(
		SavePos()
	)
)



fn PxExporterSaveLastParameters = 
(
	global px_exporter_options
	if px_exporter_options.open do
	(
		PxExporterParameters.bFolderName = px_exporter_general.cb_folder_name.checked
		PxExporterParameters.sFolderName = px_exporter_general.txt_folder_name.text
		PxExporterParameters.bIncludeFBX = px_exporter_general.cb_include_fbx.checked
		
		--PxExporterParameters.bExportPhysXScene = px_exporter_scene_settings.cb_export_scene.checked
		PxExporterParameters.iPhysXSceneFormat = px_exporter_scene_settings.rb_file_format.state

		if px_exporter_clothing.open do
		(
			--PxExporterParameters.bExportClothing = px_exporter_clothing.cb_export_clothing.checked
			PxExporterParameters.iClothingFormat = px_exporter_clothing.rb_file_format.state
			PxExporterParameters.bExportCTP = px_exporter_clothing.cb_also_export_ctp.checked
			PxExporterParameters.bExportCTW = px_exporter_clothing.cb_also_export_ctw.checked
			PxExporterParameters.iTriangleWindingReverse = px_exporter_clothing.dl_triangle_winding.selection
			PxExporterParameters.bIncludeHulls = px_exporter_clothing.cb_include_collision_hulls.checked
			PxExporterParameters.bOmitMeshSubpartName = px_exporter_clothing.cb_omit_subpart_name.checked
		)

		if px_exporter_destruction.open do
		(
			PxExporterParameters.iDestructionFormat = px_exporter_destruction.rb_file_format.state
		)
		
		PxExporterParameters.bValidateScne = px_exporter_options.cb_validateScene.checked
	)
)


fn PxExporterLoadLastParameters = 
(
	global px_exporter_options
	if px_exporter_options.open do
	(
		px_exporter_general.cb_folder_name.checked = PxExporterParameters.bFolderName
		px_exporter_general.txt_folder_name.text = PxExporterParameters.sFolderName
		px_exporter_general.cb_include_fbx.checked = PxExporterParameters.bIncludeFBX
		
		--px_exporter_scene_settings.cb_export_scene.checked = PxExporterParameters.bExportPhysXScene
		px_exporter_scene_settings.rb_file_format.state = PxExporterParameters.iPhysXSceneFormat

		if px_exporter_clothing.open do
		(
			--px_exporter_clothing.cb_export_clothing.checked = PxExporterParameters.bExportClothing
			px_exporter_clothing.rb_file_format.state = PxExporterParameters.iClothingFormat
			px_exporter_clothing.cb_also_export_ctp.checked = PxExporterParameters.bExportCTP
			px_exporter_clothing.cb_also_export_ctw.checked = PxExporterParameters.bExportCTW
			px_exporter_clothing.dl_triangle_winding.selection = PxExporterParameters.iTriangleWindingReverse
			px_exporter_clothing.cb_include_collision_hulls.checked = PxExporterParameters.bIncludeHulls
			px_exporter_clothing.cb_omit_subpart_name.checked = PxExporterParameters.bOmitMeshSubpartName
		)
		
		if px_exporter_destruction.open do
		(
			px_exporter_destruction.rb_file_format.state = PxExporterParameters.iDestructionFormat
		)
		
		px_exporter_options.cb_validateScene.checked = PxExporterParameters.bValidateScne

		px_exporter_options.cb_exportSelectedOnly.checked = nvpx.GetExporterMode PX_EXPORTER_SELECTED_ONLY
		px_exporter_options.cb_exportVisibleOnly.checked = nvpx.GetExporterMode PX_EXPORTER_VISIBLE_ONLY
	)
)

fn PxShowExportOptionsDialog =
(
	global px_exporter_options
	if not px_exporter_options.open do
	(
		wndSize = getMAXWindowSize()
		wndSizeY = 480
		pos = px_exporter_options.LoadPos()
		width = 200
		CreateDialog px_exporter_options width wndSizeY escapeEnable:false pos:pos --modal:true

		if not nvpx.IsApexAvailable() do
		(
			local space = -210
			px_exporter_options.theSubRollout.height += space
			px_exporter_options.cb_exportSelectedOnly.pos.y += space
			px_exporter_options.cb_exportVisibleOnly.pos.y += space
			px_exporter_options.cb_validateScene.pos.y += space
			px_exporter_options.bt_export.pos.y += space
			px_exporter_options.bt_cancel.pos.y += space
			px_exporter_options.height += space
		)
		
		-- set up last parameters
		PxExporterLoadLastParameters()

		-- set enable state to some controls
		px_exporter_general.SetEnableStateToControls()
		if px_exporter_clothing.open do px_exporter_clothing.SetEnableStateToControls()
		if px_exporter_destruction.open do px_exporter_destruction.SetEnableStateToControls()
	)
	setFocus px_exporter_options
)

fn PxShowExportOptions fullFileName noPrompt =
(
	PxExporterParameters.fileNameInputDone = true  -- set this to not let user input file name again and it will clear later
	PxExporterParameters.sLastSavingName = getFilenameFile fullFileName
	PxExporterParameters.sLastSavingFolder = getFilenamePath fullFileName
	--format " PxShowExportOptions names: % % \n" PxExporterParameters.sLastSavingFolder 	PxExporterParameters.sLastSavingName
	PxShowExportOptionsDialog()
	if noPrompt do
	(
		px_exporter_options.bt_export.pressed()
	)
)

fn PxExportPxProj filename exportSelected =
(	
	if (filename != undefined) and (filename.count > 0) do
	(
		exportFile filename selectedOnly:exportSelected using:PhysX_and_APEX_Exporter
	)
)
	
fn PxExportPxProj_Prompting exportSelected =
(
	filename = getSaveFileName caption:nvpxText.UI_EXPORT_PROJECT_CAPTION types:(nvpxText.UI_EXPORT_PROJECT_FILETYPE+"(*.PXPROJ)|*.PXPROJ|")
	PxExportPxProj filename exportSelected
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAHiLXxJ1ZzRcEE01Xg7oSb62hw0ObY1caD
-- xDHbbgsNwBklAhjcw8vnSA4CRw+3++Tsjznq+aqp/FNmp/M7D5sT4XTS6n0ZRDiy
-- 9ZijoP5RqKGtzqCH5RfQJdx4eVlzq3wpFVtI1Az44vkOD6OzOCI79485PYA2q0bI
-- mJh/JFpk2Ba2kasW9Nd5Ze3t8Sd1IemC8NkfeASyZYe0Y4iYF9Zij8/to50aybsr
-- hIy5hnb2TzEI/4azQp3UD4uLQYvaAA1jT51QlL1mAiVEhkb3Zm9XZX3BoEYhoopu
-- TGgYT+MS3NE9Ts3A7JLzsXdbbwr9EW5+C5p0H3Syts+QcP2LSBI1
-- -----END-SIGNATURE-----